//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;

namespace ProfilingSamples
{
	public class FinallyMain 
	{
		private void FinallyFunction()
		{
			try
			{
				TimeSpan ts = new TimeSpan(Environment.TickCount);
				throw new ApplicationException(string.Format("{0} . . .", ts.ToString()));
			}
			finally
			{
				Console.WriteLine("finally");
			}
		}
		private void FinallyThread()
		{
			while(true)
			{
				try
				{
					FinallyFunction();
				}
				catch(ApplicationException ae)
				{
					Console.WriteLine("FinallyThread restartuje: {0}", ae.Message);
				}
				catch(Exception e)
				{
					Console.WriteLine("FinallyThread przerywa prac: {0}", e.Message);
					return;
				}
				// Wyjtek bdzie zgaszany co p sekundy.
				Thread.Sleep(500);
			}
		}
		private void TestThread()
		{
			Thread re = new Thread(new ThreadStart(FinallyThread));
			try
			{
				re.Start();
				Thread.Sleep(Timeout.Infinite);
			}
			catch(Exception e)
			{
				Console.WriteLine("TestThread przerywa prac: {0}", e.Message);
				re.Abort();
			}
		}
		static void Main(string [] args)
		{
			FinallyMain m = new FinallyMain();
			Thread testThread = new Thread(new ThreadStart(m.TestThread));
			testThread.Start();
			string input = Console.ReadLine();
			testThread.Abort();
			testThread.Join();
		}
	}
}